
//#include "game/Init.as";
#include "editor/init.as";
//#include "core/Entities/Actor.as";

Control@ CONTROL;
DirectionalLight@ dirlight;
//EnvironmentLight@ light;
Quaternion Yaw;
Quaternion Pitch;

Scene@ MAIN_SCENE;
Scene@ INTERFACE_SCENE;
Scene@ SKYBOX_SCENE;
Camera@ MAIN_CAM;
Camera@ MAIN_CAM2;
Camera@ INTERFACE_CAM;
Camera@ SKYBOX_CAM;

Window@ MAIN_WINDOW;
Window@ SKYBOX_WINDOW;
ResourcePool@ pool;
Object@ sphere;
ObjectFactory@ objectFactory;
Timer@ MAIN_TIMER;
float tNr = 0;
Viewport@ v1;
Viewport@ v2;
DebugInfo@ debugInfo;
String ASSETS_LOCATION = "../../Assets/";
void main(Control@ c) {

	@CONTROL = c;
	@MAIN_TIMER = CONTROL.createTimer(1, true);
	MAIN_TIMER.start();
	
	@pool = ResourcePool();
	
	@objectFactory = ObjectFactory(pool);
	Renderer@ renderer;
	@renderer = OpenGL4Renderer();
	CONTROL.setRenderer(renderer);
	
	//@stepHandler = CONTROL.createDelegate("void doStep(pUInt)");	
	// @t = CONTROL.createTimer(10, true);
	// @moveTest = CONTROL.createDelegate("void doMove()", t);
	// t.start();
	@MAIN_WINDOW = renderer.createWindow(1280, 720, false);
	MAIN_WINDOW.open();
	//MAIN_WINDOW.GrabInput = true;
	OctreePartition p1;
	OctreePartition p2;
	OctreePartition p3;
	@MAIN_SCENE = Scene(p1);
	@SKYBOX_SCENE = Scene(p3);
	@INTERFACE_SCENE = Scene(p2);
	
	@MAIN_CAM = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);
	//@MAIN_CAM2 = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 100.0f);
	@SKYBOX_CAM = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);
	//@c2 = Camera(pFloat(-MAIN_WINDOW.width)/2, pFloat(MAIN_WINDOW.width)/2, pFloat(-MAIN_WINDOW.height)/2, pFloat(MAIN_WINDOW.height)/2, 0.1f, 1000.0f);
	@INTERFACE_CAM = Camera(-640, 640, 360,-360, 0.0f, 100.0f);
	INTERFACE_CAM.translate(0,-100,0);
	//@INTERFACE_CAM = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);

	//Viewport @v1 = Viewport(0, 0, MAIN_WINDOW.width / 2, MAIN_WINDOW.height / 2);
	@v1 = Viewport(0, 0, MAIN_WINDOW.width, MAIN_WINDOW.height);
	@v2 = Viewport(0, 0, MAIN_WINDOW.width, MAIN_WINDOW.height);
	
	v1.addCamera(0, SKYBOX_CAM);
	v1.addCamera(1, MAIN_CAM);
	//v1.addCamera(1, MAIN_CAM2);
	v1.addCamera(2, INTERFACE_CAM);
	//v1.enableClear(Color(BG_COLOR));
	v1.enableClear(Color(120, 180, 210, 255));
	v2.enableClear(Color(100, 100, 100, 255));
	
	MAIN_WINDOW.addViewport(v1);
	//sMAIN_WINDOW.addViewport(v2);
	
	MAIN_SCENE.add(MAIN_CAM);
	//@MAIN_CAM2.sceneRef = MAIN_SCENE;
	SKYBOX_SCENE.add(SKYBOX_CAM);
	INTERFACE_SCENE.add(INTERFACE_CAM);
	
	//MAIN_CAM2.disable();
	MAIN_CAM.enable();
	INTERFACE_CAM.enable();
	SKYBOX_CAM.enable();
		
	CONTROL.addScene(MAIN_SCENE);	
	CONTROL.addScene(INTERFACE_SCENE);	
	CONTROL.addScene(SKYBOX_SCENE);	

	@dirlight = DirectionalLight();
	dirlight.setPosition(0,0,10);
	dirlight.rotate(1, 0, 0, -0.7*PI);
   //	mainTestLight.scale(50);
  	dirlight.color = Color(255,255,255,255);
  	MAIN_SCENE.add(dirlight);
	
	@debugInfo = DebugInfo();
	debugInfo.proxies = true;
	debugInfo.skeletons = false;
	debugInfo.boundingvolumes = false;
	debugInfo.setDefaultMat(pool.getMaterial("Resources/Renderer/GL4Deferred/Materials/defaultDebug.pmat"));
	@MAIN_CAM.debugInfoRef = debugInfo;
	
	init();
	//menu_init();
	//game_init();
	
}

